-- when user changes units, we will change the values of parameters

global PxMeterToSystemUnit = 1.0
global PxMeterToDisplayUnit = 1.0
global gPxVolumeUnitChange
global PxSaveGlobalParams
global physXpaneldata

fn PxGetMeterToUnit unitType =
(
	if unitType == #inches then  39.3701
	else if unitType == #feet then  3.28084
	else if unitType == #miles then  0.000621371
	else if unitType == #millimeters then  1000
	else if unitType == #centimeters then  100
	else if unitType == #meters then  1.0
	else if unitType == #kilometers then  0.001
	else if unitType == #Frac_In then  39.3701
	else if unitType == #Dec_In then   39.3701
	else if unitType == #Frac_Ft then  3.28084
	else if unitType == #Dec_Ft then   3.28084
	else if unitType == #Ft_Frac_In then  3.28084
	else if unitType == #Ft_Dec_In then   3.28084
	else (format nvpxText.TXT_UNITCHANGES_INFO_UNKNOWN; 1.0)
)

fn PxSystemUnitChangeFactor srcUnit srcScale destUnit destScale = 
(
	srcFactor = PxGetMeterToUnit(srcUnit) / srcScale
	destFactor= PxGetMeterToUnit(destUnit)/ destScale
	(destFactor / srcFactor)
)

fn PxGetDisplayUnitFactor =
(
	if  units.DisplayType == #Generic then 
	(
		(PxGetMeterToUnit(units.SystemType) / units.SystemScale)
	)
	else if  units.DisplayType == #Metric then
	(
		PxGetMeterToUnit(units.MetricType)
	)
	else if  units.DisplayType == #US then
	(
		PxGetMeterToUnit(units.USType)
	)
	else -- #custom
	(
		(PxGetMeterToUnit(units.CustomUnit) / units.CustomValue)
	)
)

fn PxReadSystemUnit =
(
	PxMeterToSystemUnit = PxGetMeterToUnit(units.SystemType) /  units.SystemScale
	nvpx.setMeterToSystemUnit(PxMeterToSystemUnit)
	-- density be in gram/cm^2 while mass is in kg
	gPxVolumeUnitChange = (PxMeterToSystemUnit * PxMeterToSystemUnit * PxMeterToSystemUnit) / 1000
)

fn PxReadMaxUnit =
(
	PxReadSystemUnit()
	PxMeterToDisplayUnit = PxGetDisplayUnitFactor()
)

fn PxKeepGlobalParametersUnchanged changeFactor =
(
	global px_physXPanel
	global px_sdk_gravityx
	global px_sdk_gravityy
	global px_sdk_gravityz
	global px_sdk_skinwidth
	global px_sdk_contactDistance
	global px_sdk_sleeplinevel
	global px_sdk_bouncethresh
	global px_sdk_ccd_epsilon
	global PxSetPhysXPanelInterfaceFromGlobalParams

	px_sdk_gravityx = px_sdk_gravityx * changeFactor
	px_sdk_gravityy = px_sdk_gravityy * changeFactor
	px_sdk_gravityz = px_sdk_gravityz * changeFactor
	-- update to physx panel data before pluginInterfaces::UpdateGravityFromForce
	physXpaneldata.gravity = case physXpaneldata.gravityDirection of
	( 
		1: px_sdk_gravityx
		2: px_sdk_gravityy
		3: px_sdk_gravityz
	)
	nvpx.setGravity [px_sdk_gravityx, px_sdk_gravityy, px_sdk_gravityz]     -- update gravity
	--px_sdk_sleeplinevel = px_sdk_sleeplinevel * changeFactor
	px_sdk_skinwidth = px_sdk_skinwidth * changeFactor
	px_sdk_contactDistance = px_sdk_contactDistance * changeFactor
	
	px_sdk_bouncethresh = px_sdk_bouncethresh * changeFactor
	px_sdk_ccd_epsilon = px_sdk_ccd_epsilon  * changeFactor
	-- Ensure that the global parameters are updated, since this is not automatic on file save
	PxSaveGlobalParams()
	
	-- update to PhysXPanelInterface.instance
	PxSetPhysXPanelInterfaceFromGlobalParams()
	
	if px_physXPanel.open then px_physXPanel.refreshPage()
)

fn PxKeepPhysicsValuesUnchanged changeFactor =
(
	global nvConstraint
	global PxGetModRB

	volumeFactor = (changeFactor * changeFactor * changeFactor)
	massFactor = 1.0/volumeFactor

	-- 1. PhysX objects
	currentMod = modPanel.getCurrentObject()
	if currentMod != undefined then clearSelection()
	for i in objects do
	(
		cls = classof(i)
		if cls == nvConstraint then
		(
			i.linearPosition = i.linearPosition * changeFactor
			i.projectionDist = i.projectionDist * changeFactor

			--DH: Fix joints breaking too easily.
			i.maxForce = i.maxForce * massFactor * changeFactor

		)
		else
		(
			modRB = PxGetModRB i
			if modRB != undefined then
			(
				-- DH: InitialVelocity is a normal and is scaled by speed so not necessary
				-- modRB.InitialVelocityX = modRB.InitialVelocityX * changeFactor
				-- modRB.InitialVelocityY = modRB.InitialVelocityY * changeFactor
				-- modRB.InitialVelocityZ = modRB.InitialVelocityZ * changeFactor
				
				-- DH: MassCenter is already in system units since control is "universal"
				-- modRB.MassCenterX = modRB.MassCenterX * changeFactor
				-- modRB.MassCenterY = modRB.MassCenterY * changeFactor
				-- modRB.MassCenterZ = modRB.MassCenterZ * changeFactor
				
				-- make it recalculate its mass
				-- notes: can not change mass, changing mass will cause density change.
				modRB.density = modRB.density
				if modRB.meshInflation > 0.0 then
					modRB.meshInflation = modRB.meshInflation * changeFactor
			)
		)
	)

	-- 2. PhysX tool panel
	PxKeepGlobalParametersUnchanged(changeFactor)
)

fn PxUnitsChange =
(
	global PxStopSimulation
	global PxOpeningNewFile
	global PxDeleteBrokenRBs
		
	if PxOpeningNewFile then PxDeleteBrokenRBs() -- for bug #5187: Script exception after loading an old Max file
	
	meterToSystemUnit = PxGetMeterToUnit(units.SystemType) /  units.SystemScale
	meterToDisplayUnit = PxGetDisplayUnitFactor()
	if PxMeterToSystemUnit != meterToSystemUnit then (
		-- stop simulation first
		PxStopSimulation()
		-- update physics objects to keep their values not changed
		changeFactor = meterToSystemUnit / PxMeterToSystemUnit
		-- 0. update unit parameters
		PxReadSystemUnit()
		
		-- 1. update physics objects to keep their values not changed in display
		-- note that mass should be changed if keeping density value unchanged
		if not PxOpeningNewFile then PxKeepPhysicsValuesUnchanged(changeFactor)
	)
	if PxMeterToDisplayUnit != meterToDisplayUnit then (
		PxMeterToDisplayUnit = meterToDisplayUnit
		--format " find display unit changes, PxMeterToDisplayUnit = %\n"  PxMeterToDisplayUnit 
	)
	
)

-- set system unit
-- units.SystemType = #feet
-- units.SystemScale = 1.0

-- init relative unit manage things
PxReadMaxUnit()

-- register unit change event callback
callbacks.removeScripts id:#PhysXUnitChange
callbacks.addScript #unitsChange "PxUnitsChange()" id:#PhysXUnitChange
